#!/bin/bash
# проверка прав
root_uid=0 
if [ "$UID" -eq "$root_uid" ] 
then echo -n
else
echo "Вы необладаете достаточными правами для запуска программы !"
read
exit 0
fi
clear
#отмонтирование всех устройств
umount -a 2>/dev/nul 
# функция, которая проверяет введены ли данные пользователем
proverka () 
{
if [ -z "$REPLY" ]
then echo "Данные не были введены, попробуйте еще раз сначала" ; exit 0
fi
}
#основные переменных
directory_archiv=/media/archiv
directory_to_archiv=/media/to_archiv
echo -e "\E[32m\033[1m Программа резервного копирования и последующего восстановления системы ver1.0\033[0m" ###; tput sgr0
echo -e "\E[36mДля запуска процесса архивирования введите аrc, для разархивирования -ras, для просмотра описания - help" ; tput sgr0
read action
case $action in

	"arc")
	echo -e "\E[36mПроцесс архивирования" ; tput sgr0
	echo -e "\E[36mВведите имя устройство, которое будет архивироваться(sda'цифровой индекс')" ; tput sgr0
	read
	proverka
	dev=$REPLY
	
		if [ -d "$directory_archiv" ]
		then echo -n
		else mkdir $directory_archiv
		fi
		
		mount /dev/$dev $directory_archiv/
				
	echo -e "\E[36mВведите имя устройство, которое будет использовано для хранения архива(sda'цифровой индекс')" ; tput sgr0	
	read 
	proverka
	to_dev=$REPLY
	
		if [ -d "$directory_to_archiv" ]
		then echo -n
		else mkdir $directory_to_archiv
		fi
	
		mount /dev/$to_dev $directory_to_archiv/
	
	echo -e "\E[36mВведите имя архива" ; tput sgr0		
	read 
	name=$(date | awk '{print $6 $2 $3}')
	name_archiv=${REPLY:-standard$name}
	
	echo -e "\E[36mАрхивирование начато !!!" ; tput sgr0	
	tar -czf  $directory_to_archiv/$name_archiv.tar $directory_archiv --exclude=$directory_to_archiv 2>/dev/null
	echo -e "\E[36mОперация выполнена !!!" ; tput sgr0	
		
	;;
	"ras") 
	echo -e "\E[36mПроцесс разархивирования" ; tput sgr0
	#echo "Внимание данный процесс применим только для файловой системы EXT3"
	echo -e "\E[36mВведите имя устройство, куда будет распакован архив (sda'цифровой индекс')" ; tput sgr0		
	read
	proverka
	dev=$REPLY
	
		if [ -d "$directory_archiv" ]
		then echo -n
		else mkdir $directory_archiv
		fi
	echo -e "\E[36mВведите имя устройство, где хранится архив (sda'цифровой индекс')" ; tput sgr0
	read 
	proverka
	to_dev=$REPLY
	
		if [ -d "$directory_to_archiv" ]
		then echo -n
		else mkdir $directory_to_archiv
		fi
		mount /dev/$to_dev $directory_to_archiv
	
	echo -e "\E[36mВведите имя архива" ; tput sgr0
	read
	proverka
	name_archiv=$REPLY
	#name=$(date | awk '{print $6 $2 $3}')
	#name_archiv=${REPLY:-standard$name}
	echo -e "\E[31m\033[1mВНИМАНИЕ ПОСЛЕДУЮЩИЕ ОПЕРАЦИИ ПРИВЕДУТ К НЕОБРАТИМЫМ ПОСЛЕДСТВИЯМ\033[0m" ###; tput sgr0
	echo -e "\E[31mДЛЯ ПРОДОЛЖЕНИЯ ВВЕДИТЕ 'ok'" ; tput sgr0
		read act
		if [ -z "$act" ]
		then exit 0
		else echo -e "\E[31mУКАЖИТЕ ТИП ФАЙЛОВОЙ СИСТЕМЫ ДЛЯ РАЗДЕЛА (ntfs, fat, ext3)" ; tput sgr0 
		fi
	
		read filesystem
		case $filesystem in
		"ext3" ) 
		echo -e "\E[31mПроисходит форматирование" ; tput sgr0		
		mkfs.ext3 /dev/$dev &> /dev/null
		echo -e "\E[31mФорматирование выполнено" ; tput sgr0
		;;
		"ntfs" ) 
		echo -e "\E[31mПроисходит форматирование" ; tput sgr0	
		mkfs.ntfs /dev/$dev &> /dev/null
		echo -e "\E[31mФорматирование выполнено" ; tput sgr0
		;;
		"fat" ) 
		echo -e "\E[31mПроисходит форматирование" ; tput sgr0	
		mkfs.vfat /dev/$dev &> /dev/null
		echo -e "\E[31mФорматирование выполнено" ; tput sgr0
		;;
		esac	

	mount /dev/$dev $directory_archiv	
	echo -e "\E[36mРазархивирование начато !!!" ; tput sgr0	
	tar -xf $directory_to_archiv/$name_archiv.tar -C / 2>/dev/null
	echo -e "\E[36mОперация выполнена !!!" ; tput sgr0
	;;
	
	"help") 
clear
echo -e '\E[34;47m'"Описание к 'Программе резервного копирования и последующего восстановления системы ver1.0'

1.Запаковка 

1.1 Введите имя устройство, которое будет архивироваться(sda'цифровой индекс')
Вводим имя:
Если источник Flash носитель, то вероятное имя: sdb, sdc и т.д.
Номер к имени добавляется в зависимости от порядкового номера раздела: 1, 2 и т.д.
Пример: sda1 т.е. жесткий диск (sda) первый раздел (1) 

1.2 Введите имя устройство, которое будет использовано для хранения архива(sda'цифровой индекс')
Ввод данных аналогичен п 1.1 не забывая, что указывается раздел для хранения архива

1.3 Введите имя архива
Вводим имя архива без указания расширения
Пример: archiv_test
Если имя архива не вводится, то используется стандартное имя:
standard2010Июль15  ('2010Июль15' - автоматически проставляется системная дата)

2. Распаковка

2.1 Введите имя устройство, куда будет распакован архив (sda'цифровой индекс')
Полностью аналогично п 1.1 (раздел куда будем восстанавливать систему)

2.2 Введите имя устройство, где хранится архив (sda'цифровой индекс')
Полностью аналогично п 1.2 (раздел откуда будем восстанавливать систему, тот раздел на котором находится архив)

2.3 Введите имя архива
В это поле вводится точное имя архива без расширения
Если в это поле не ввести данные, то происходит выход из программы

2.4 ВНИМАНИЕ ПОСЛЕДУЮЩИЕ ОПЕРАЦИИ ПРИВЕДУТ К НЕОБРАТИМЫМ ПОСЛЕДСТВИЯМ
Система предупреждает о том, что в случае ошибочных данных возможна потеря информации
Будьте внимательны при вводе данных, т.к. после подтверждения происходит форматирование раздела, на который в дальнейшем будет восстановлена система

2.4 УКАЖИТЕ ТИП ФАЙЛОВОЙ СИСТЕМЫ ДЛЯ РАЗДЕЛА (ntfs, fat, ext3)
В поле вводится одно из тех значений, что указано в скобках т.е. для WIN систем либо fat, либо ntfs, а для Unix систем ext3


Примечание к ver1.0
-запаковка и распаковка происходит только в корневой каталог раздела
-поддержка только EXT3 файловой системы 
	
С уважением, Plakhov Dmitry pldm-071@yandex.ru
" 
tput sgr0
;;

esac
exit 0
